
// FILE DemoThreeBody.cc 

#include "VNODE.h"
#include "ThreeBody.h"


int main()
{
  VnodeInit();
  
  PtrODENumeric ODE = new ThreeBody; 
  PtrDataRepr DataRepr = new 
    TAYLOR_EXPANSION<ThreeBodyTaylGenODE,ThreeBodyTaylGenVAR>;
  
  ODE->LoadProblemParam( 1 );

  PtrODESolver Solver = new SOLVER_2( ODE, DataRepr );
  
  cout << "*** Integrating " << ODE->GetName() << endl;
  Solver -> Integrate();

  cout << "\n Enclosure at T = " << ODE->GetTend() << endl;
  PrintVec( ODE->GetTightEncl() );


  ODE->LoadProblemParam( 2 );
  Solver -> Integrate();

  cout << "\n Enclosure at T = " << ODE->GetTend() << endl;
  PrintVec( ODE->GetTightEncl() );

  return 0;
}



