// FILE DemoVDP.cc

#include "VNODE.h"  
#include "VDP.h" 

int main()
{
  // Initialize VNODE.
  VnodeInit();  
  
  // Create the ODE problem and the data representation object.
  PtrODENumeric ODE = new VDP; 
  PtrDataRepr DataRepr = new TAYLOR_EXPANSION<VDPTaylGenODE,VDPTaylGenVAR>;
  
  // Set the problem parameters.
  ODE->LoadProblemParam(1); 
  
  // Create a solver.
  PtrODESolver Solver = new SOLVER_2( ODE, DataRepr ); 

  // The solution will be plotted. 
  Solver->GraphOutput(true); 
  
  cout << endl << "*** Integrating " << ODE->GetName() << endl;

  Solver -> Integrate();
  
  cout << endl << "   Enclosure at T = " << INTERVAL(ODE->GetTcur()) << endl;
  PrintVec( ODE->GetTightEncl() );


  // Plot Y(1) vs. t.
  ODE->DisplaySolution(1); 

  // Save this plot in VDP.eps.
  ODE->DisplaySolution( 1, "VDP.eps" ); 
  
  return 0;
}
