
#ifndef INCLUDED_Marletta_H
#define INCLUDED_Marletta_H

#include "odenum.h"  


template <class Y_TYPE> 
void MarlettaTemplate( Y_TYPE *yp, const Y_TYPE *y )
{
#define U1  y[0]
#define U2  y[1]
#define U3  y[2]
#define U4  y[3]
#define U5  y[4]
#define U6  y[5]
#define U7  y[6]
#define U8  y[7]
#define U9  y[8]
#define U10 y[9]

#define F1  yp[0]
#define F2  yp[1]
#define F3  yp[2]
#define F4  yp[3]
#define F5  yp[4]
#define F6  yp[5]
#define F7  yp[6]
#define F8  yp[7]
#define F9  yp[8]
#define F10 yp[9]

  
  Y_TYPE LwmQ, S, S1, S2, S3, DETS, SINV11, SINV12, SINV22, AU11,
AU12, AU21, AU22, AU31, AU32, AU41, AU42, UTAU11, UTAU12, UTAU21,
UTAU22, SINVUTAU11, SINVUTAU12, SINVUTAU21, SINVUTAU22, A, B, D, C, F,
ALPHA, BETA, DET, Y1, Y2, Y3, Y4, Y5, Y6, G11, G12, G13; 

  
  LwmQ = U10;
  S = 0.0;
  S1 = U1*U1 + U3*U3 + U5*U5 + U7*U7;
  S2 = U2*U2 + U4*U4 + U6*U6 + U8*U8;
  S3 = U1*U2 + U3*U4 + U5*U6 + U7*U8;
  DETS = S1*S2-S3*S3;
  SINV11 = S2/DETS;
  SINV12 = -S3/DETS;
  SINV22 = S1/DETS;
  AU11 = U3;
  AU12 = U4;
  AU21 = U7;
  AU22 = U8;
  AU31 = -LwmQ*U1;
  AU32 = -LwmQ*U2;
  AU41 = S*U3-U5;
  AU42 = S*U4-U6;
  UTAU11 = U1*AU11+U3*AU21+U5*AU31+U7*AU41;
  UTAU12 = U1*AU12+U3*AU22+U5*AU32+U7*AU42;
  UTAU21 = U2*AU11+U4*AU21+U6*AU31+U8*AU41;
  UTAU22 = U2*AU12+U4*AU22+U6*AU32+U8*AU42;
  SINVUTAU11 = SINV11*UTAU11+SINV12*UTAU21;
  SINVUTAU12 = SINV11*UTAU12+SINV12*UTAU22;
  SINVUTAU21 = SINV12*UTAU11+SINV22*UTAU21;
  SINVUTAU22 = SINV12*UTAU12+SINV22*UTAU22;
  // U9 contains Argdet Theta, where Theta is the Theta
  // matrix associated with U. Putting UM := matrix(2,2,[[U1,U2],[U3,U4]])
  // and VM := matrix(2,2,[[U5,U6],[U7,U8]]) in Maple notation, we have
  // Theta = (VM+iUM).inverse(VM-iUM). 
  A = U1*U4+U5*U8-U2*U3-U6*U7;
  B = U1*U8-U4*U5-U2*U7+U3*U8;
  D = 2.0*(-U1*U6+U2*U5);
  C = -U2*U3-U6*U7+U1*U4+U5*U8;
  F = -U3*U6+U2*U7-U1*U8+U4*U5;
  ALPHA = -U1*U4+U5*U8+U2*U3-U6*U7;
  BETA = -U1*U8-U4*U5+U2*U7+U3*U6;
  // THETA[1,1] = Y1 + i Y2; THETA[1,2] = THETA[2,1] = Y3 + i Y4;
  // THETA[2,2] = Y5 + i Y6
  DET = ALPHA*ALPHA+BETA*BETA;
  Y1 = (A*ALPHA+B*BETA)/DET;
  Y2 = (B*ALPHA-A*BETA)/DET;
  Y3 = D*BETA/DET;
  Y4 = D*ALPHA/DET;
  Y5 = (C*ALPHA+F*BETA)/DET;
  Y6 = (F*ALPHA-C*BETA)/DET;
  G11 = (0.5)*LwmQ*(Y1*Y1-2*Y1+1+Y2*Y2+Y3*Y3+Y4*Y4);
  G12 = -(0.5)*S*(Y3*Y3+Y4*Y4+Y5*Y5-2*Y5+1+Y6*Y6);
  G13 = -Y3*Y2+Y4*Y1+2*Y4+(0.5)*(Y3*Y3+Y4*Y4+Y5*Y5+Y6*Y6)-Y4*Y5+Y6*Y3+Y5/2;
  F1 = AU11 - U1*SINVUTAU11+U2*SINVUTAU21;
  F2 = AU12 - U1*SINVUTAU12+U2*SINVUTAU22;
  F3 = AU21 - U3*SINVUTAU11+U4*SINVUTAU21;
  F4 = AU22 - U3*SINVUTAU12+U4*SINVUTAU22;
  F5 = AU31 - U5*SINVUTAU11+U6*SINVUTAU21;
  F6 = AU32 - U5*SINVUTAU12+U6*SINVUTAU22;
  F7 = AU41 - U7*SINVUTAU11+U8*SINVUTAU21;

  F8 = AU42 - U7*SINVUTAU12+U8*SINVUTAU22;
  F9 = G11 + G12 + G13 + 0.5;
  F10 = 0;

#undef U1
#undef U2
#undef U3
#undef U4
#undef U5
#undef U6
#undef U7
#undef U8  
#undef U9  
#undef U10 

#undef F1  
#undef F2  
#undef F3  
#undef F4  
#undef F5  
#undef F6  
#undef F7  
#undef F8  
#undef F9  
#undef F10 

}

#include "declode.h"
DECLARE_ODE_PROBLEM(Marletta,10,MarlettaTemplate,"Marletta's Problem");

#endif






