// FILE VDP.cc

#include "VDP.h"

void VDP :: LoadProblemParam( int ParamSet )
{
  INTERVAL_VECTOR Y(2);      

  if ( ParamSet == 1 )
    {
      // Set initial an final points.
      SetT0(0);
      SetTend(10);
      
      Y(1) = INTERVAL(2.0); 
      Y(2) = INTERVAL(0.0); 
      
      // Set absolute and relative tolerances. 
      SetAtol(1e-10); 
      SetRtol(0);           
    }
  
  if ( ParamSet == 2 )
    {
      SetT0(0);
      SetTend(20);
      
      Y(1) = INTERVAL(2.0);
      Y(2) = INTERVAL(0.0);
    }

  // Set an initial condition.
  SetInitCond(Y); 
}
