// FILE declode.h 

#include "taylexp.h"

/** Macro for creating a problem class and Taylor series generator classes.

  This macro generates declarations for three classes: a class derived from ODE_NUMERIC,
  a class derived from TAYLOR_ODE_TAD and a class derived from TAYLOR_ODE_TAD.

  @param CLASS_NAME name for the derived ODE_NUMERIC class and a
  prefix for the class names of the classes derived from
  TAYLOR_ODE_TAD and TAYLOR_ODE_TAD.

  @param PROBLEM_SIZE size of the problem 

  @param FUNCTION_NAME a name of a template function for computing \f$y^\prime = f(y)\f$

  @param PROBLEM_NAME a name for the problem class.  */
#define DECLARE_ODE_PROBLEM(CLASS_NAME,PROBLEM_SIZE,FUNCTION_NAME,PROBLEM_NAME)\
class CLASS_NAME : public ODE_NUMERIC\
{\
public:\
 CLASS_NAME() : ODE_NUMERIC(PROBLEM_SIZE, FUNCTION_NAME, PROBLEM_NAME) {;}\
  \
  ~CLASS_NAME() {}\
  void LoadProblemParam( int ); \
};\
\
\
class CLASS_NAME##TaylGenODE : public TAYLOR_ODE_TAD\
{\
public:\
 CLASS_NAME##TaylGenODE() : TAYLOR_ODE_TAD(PROBLEM_SIZE, FUNCTION_NAME ) {;}\
};\
\
\
class CLASS_NAME##TaylGenVAR : public TAYLOR_VAR_TAD\
{\
public:\
 CLASS_NAME##TaylGenVAR() : TAYLOR_VAR_TAD(PROBLEM_SIZE, FUNCTION_NAME) {;}\
};

