
// FILE paral.cc


#include <typeinfo>
#include "paral.h"
#include "vndinl.h"


#define CheckParallDimensions(y,A,r) \
assert( Dimension(y)>0 && \
	Square(A,Dimension(R)) && \
	Dimension(R)== Dimension(Y) );
  
  
PARALL :: PARALL( const VECTOR & Y, 
		  const MATRIX & A, 
		  const INTERVAL_VECTOR & R ) 
  : SOLUTION( Dimension(R) )
  
{
  assert( Square(A,Dimension(R)) && Dimension(Y) == Dimension(R));
  ResizeSpace( Dimension(R) );
  SetParal( Y, A, R );
}


void PARALL :: SetParal( const VECTOR & Y, const MATRIX & A, 
			 const INTERVAL_VECTOR & R )
{
  CheckParallDimensions(Y,A,R);
  
  Yj = Y;
  Aj = A;
  Rj = R;

  SetTightEncl( Y + A*R );
}


void PARALL :: SetParal( const INTERVAL_VECTOR & Y )
{
  assert( GetDim()==Dimension(Y) );
  
  Yj = Mid(Y);
  Identity(Aj);
  Rj = Y - Yj;

  SetTightEncl( Y );
}


PARALL & PARALL :: operator = ( const SOLUTION & S )
{
  assert(GetDim()==S.GetDim());
  
  // Copy the SOLUTION part.
  SOLUTION :: operator=(S);

  Yj = Mid( S.GetTightEncl() );
  Identity( Aj );
  Rj = S.GetTightEncl() - Yj;
  
  return *this;
}


void PARALL :: ResizeSpace( int n )
{
  assert(n>0);
  
  Resize(Yj,n);
  Resize(Aj,n,n);
  Resize(Rj,n);
}














