
// FILE taylexp.h 


#ifndef INCLUDED_TAYLEXP_H
#define INCLUDED_TAYLEXP_H

#include "ttaylode.h"
#include "ttaylvar.h"
#include "datarepr.h"


/** Taylor coefficient generators.

    This class maintains pointers to Taylor coefficient generators.  
    
    @author Ned Nedialkov 
    @date   7 June 2001
*/
class TAYL_EXP : public DATA_REPR
{

public:
  
  /// Taylor coefficient generator for computing bounds on point Taylor terms
  PtrTaylGenODE PointSol;
  
  /// Taylor coefficient generator for computing bounds on interval Taylor terms
  PtrTaylGenODE IntSol;
  
  /// Taylor coefficient generator for computing bounds on interval Taylor terms
  PtrTaylGenODE RemTerm;
  
  /** Taylor coefficient generator for computing bounds on interval
    Taylor terms for the variational equation */
  PtrTaylGenVAR VarSol;
  
  /// Destructor.
  virtual ~TAYL_EXP();

};


/// Pointer to a TAYL_EXP object.
typedef TAYL_EXP* PtrTaylExp;

inline TAYL_EXP :: ~TAYL_EXP() 
{ 
  DELETE(PointSol); 
  DELETE(RemTerm); 
  DELETE(IntSol);
  DELETE(VarSol);
}


/** Template class for configuring a TAYL_EXP object.  
 */
template <class TAYLOR_ODE, class TAYLOR_VAR>
class TAYLOR_EXPANSION : public TAYL_EXP
{
public:
  
  /// Constructor
  TAYLOR_EXPANSION();
  
  /// Destructor
  ~TAYLOR_EXPANSION() {;}
};


template <class TAYLOR_ODE, class TAYLOR_VAR> 
inline TAYLOR_EXPANSION<TAYLOR_ODE,TAYLOR_VAR> :: TAYLOR_EXPANSION()
{
  PointSol = new TAYLOR_ODE;
  RemTerm  = new TAYLOR_ODE;
  IntSol   = new TAYLOR_ODE;
  VarSol   = new TAYLOR_VAR;
}


#endif
