
// FILE ttaylvar.cc 

#include "ttaylvar.h"


TAYLOR_VAR_TAD ::
TAYLOR_VAR_TAD( int n, TFadiff ptadiff ) : TAYLOR_VAR(n)
{
  assert(n>0);
  assert(ptadiff);
  
  extern int  maxlength_FINTERVAL;
  maxlength_FINTERVAL = GetMaxOrder();
  
  TFin   = new TFINTERVAL [2*n];
  assert(TFin);
  TFout  = TFin + n;
  
  GenTaylorVAR = ptadiff;
}


void TAYLOR_VAR_TAD :: 
GenerateTerms( const INTERVAL_VECTOR & Y0, const INTERVAL & H, int Order ) 
{ 
  assert( Order>0 && Order <= GetMaxOrder() && 
	  Dimension(Y0) == GetDim() &&
	  NonZero(H) 
	  );
  
  int N = GetDim();
  
  SetH( H );
  SetOrder( Order );

  GenTaylorVAR( TFout, TFin );   
  
  int row;

  // reset the previously generated terms
  for( row = 0; row < N; row++ ) 
    TFout[row].reset(); 
  
  for( row = 0; row < N; row++ ) 
    {
      // specify the point of expansion
      TFin[row][0] = Y0(row+1);      
      
      // initialize the zero-order Taylor term for the solution to the
      // variational equation
      TFin[row][0].diff( row, N );  
    }
  
  int tmp = 0;
  for( int k = 0; k < Order; k++ )
    {
      tmp++;
      
      for ( row = 0; row < N; row++ )
      	{
	  // evaluate the k-th Taylor term for the right side
	  TFout[row].eval(k);
	  
	  // evaluate the k-th Taylor term for the solution
	  TFin[row][tmp] = H*TFout[row][k]/ double(tmp);
	}
    }
}


void TAYLOR_VAR_TAD :: 
SumTerms( INTERVAL_MATRIX & Sum, int Order )
{
  assert( Order > 0 && Order <= GetOrder() &&
	  Square(Sum,GetDim()) );

    
  INTERVAL Tmp;  
  int N = GetDim();

  for ( int row = 0; row < N; row++ )
    for ( int col = 0; col < N; col++ )
      {
	Tmp = 0.0;
	
	for ( int matrix = Order; matrix >= 1; matrix-- )
	  Tmp += TFin[row][matrix].d(col);
	
	Sum(row+1, col+1) = Tmp;
      }
  
  for ( int row = 1; row <= N; row++ )
    Sum(row, row) += 1.0;
}


void TAYLOR_VAR_TAD :: 
GetOneTerm( INTERVAL_MATRIX & Y, int Term )
{
  assert( Term>=0 && Term<=GetOrder() &&
	  Square(Y,GetDim()) );
  
  int N = GetDim();

  for ( int row = 0; row < N; row++ )
    for ( int col = 0; col < N; col++ )
      Y(row+1, col+1) = TFin[row][Term].d(col);
}


TAYLOR_VAR_TAD :: ~TAYLOR_VAR_TAD() 
{ 
  delete [] TFin; 
}

