
// FILE ttaylvar.h 


#ifndef INCLUDED_TTAYLVAR_H
#define INCLUDED_TTAYLVAR_H


#include "taylvar.h"
#include "TFINTERVAL.h"


/// Pointer to a function for storing the computational graph.
typedef void (*TFadiff)( TFINTERVAL *yp, const TFINTERVAL *y );

/** Taylor coefficient generator. 

  This class uses the \c FADBAD and \c TADIFF packages to generate
  Taylor coefficients for the solution to the variational equation
  associated with 
  \f$ y^\prime = f(y) \f$, 
  \f$ y(t_{j}) \in [y_{j}] \f$.
    
  @author Ned Nedialkov 
  @date   8 June 2001 
  */
class TAYLOR_VAR_TAD : public TAYLOR_VAR
{
  
public:
  
  /** Constructor.

      @param n number of equations 
      @param ptadiff pointer to a function for storing the computational graph
      
      @pre n>0
      @pre NotNull(ptadiff) 
      */
  TAYLOR_VAR_TAD( int n, TFadiff ptadiff );
  
  
  /** Generates Taylor series terms.       
  */
  void GenerateTerms ( const INTERVAL_VECTOR & Y, 
		       const INTERVAL & h, int k ); 
  
  /** Sums Taylor series terms. 
  */
  void SumTerms      ( INTERVAL_MATRIX & Sum, int k );
  
  /** Obtains the \c k-th Taylor series term.
  */
  void GetOneTerm    ( INTERVAL_MATRIX & Yk, int k );
  
  /// Destructor
  ~TAYLOR_VAR_TAD();
  
private:
  
  /// work space
  TFINTERVAL    *TFin,  *TFout;  
  
  /// pointer to a function for storing the computational graph.
  TFadiff       GenTaylorVAR;
  
};


/// Pointer to a TAYLOR_VAR object.
typedef TAYLOR_VAR*  PtrTaylGenVAR;

#endif 
