
// FILE DemoLorenz3.cc

#include "VNODE.h"  
#include "Lorenz.h" 

int main()
{

  VnodeInit();  

  PtrODENumeric ODE = new Lorenz; 
  PtrDataRepr DataRepr = new TAYLOR_EXPANSION<LorenzTaylGenODE,LorenzTaylGenVAR>;
  ODE->LoadProblemParam(1); 

  int order = 15;
  double h = 0.001;

  // Create methods for order control, stepsize control, validating
  // existence and uniqueness and computing tight bounds on the
  // solution.
  PtrOrderCtrl OrderCtrl = new CONST_ORDER(order);
  PtrStepCtrl  StepCtrl  = new CONST_STEP(h);
  PtrInitEncl  InitEncl  = new HOE;
  PtrTightEncl TightEncl = new ITS_QR;
  
  // Create a solver.
  PtrVODESolver Solver = new VODE_SOLVER( ODE, DataRepr, OrderCtrl, StepCtrl, 
					  InitEncl, TightEncl ); 
  
  cout << endl << "*** Integrating " << ODE->GetName() << endl;
  cout << endl << "*** With the "  << Solver->GetTightEncl()->GetName() << endl;
  Solver -> Integrate();

  // Replace the ITS_QR method with the IHO method.
  Solver->SetTightEncl( new IHO( (order-1)/2, (order-1)/2 ) );
  
  cout << endl << "*** With the "  << Solver->GetTightEncl()->GetName() << endl;
  Solver -> Integrate();
  
}
