
// FILE Lorenz.h 

#ifndef INCLUDED_Lorenz_H
#define INCLUDED_Lorenz_H


#include "odenum.h"  


/* A template function for evaluating the right side.  */
template <class Y_TYPE> 
void LorenzTemplate( Y_TYPE *yprime, const Y_TYPE *y )
{
  INTERVAL sigma( 10.0 );
  INTERVAL rho( 28.0 );
  INTERVAL beta( DivBounds(8.0,3.0) ); /** DivBounds returns an
					   interval containing
					   8.0/3.0. */

  yprime[0] = sigma*( y[1]-y[0] );    
  yprime[1] = y[0]*( rho - y[2] )-y[1]; 
  yprime[2] = y[0]*y[1]-beta*y[2];    
}


// These two lines must be included.
#include "declode.h" 

DECLARE_ODE_PROBLEM(Lorenz,3,LorenzTemplate,"Lorenz System");

#endif
