// FILE VDP.h

#ifndef INCLUDED_VDP_H
#define INCLUDED_VDP_H

#include "odenum.h"  

template <typename Y_TYPE> 
void VDPtemplate( Y_TYPE *yp, const Y_TYPE *y )
{
  double MU = 2.0;  

  yp[0] = y[1];
  yp[1] = MU*(1 - sqr(y[0]))*y[1] - y[0];
} 

#include "declode.h"

DECLARE_ODE_PROBLEM(VDP,2,VDPtemplate,"Van Der Pol's Equation");

#endif
