
// FILE itsdir.h 


#ifndef INCLUDED_ITS_DIRECT_H
#define INCLUDED_ITS_DIRECT_H


#include "itsbase.h"
#include "taylctrl.h"
#include "messgs.h"

/** Direct method for computing tight enclosures on the solution.

  The \c ITS_DIRECT class implements the direct Taylor series method
  for computing tight enclosures on the solution.
  
  @author Ned Nedialkov 
  @date   1 May 2001 
  */
class ITS_DIRECT : public ITS_BASE
{	
public:									
  
  /** Constructor.  
    
    @param order maximum order allowed. The default value is 
    TAYLOR_CTRL::GetMaxOrder()
    
    @pre order>0 && order<=TAYLOR_CTRL::GetMaxOrder()
    */
  ITS_DIRECT( int order = TAYLOR_CTRL::GetMaxOrder() );
  
  
  /** Computes a tight enclosure. 
   */
  virtual void Compute( INTERVAL_VECTOR & Ytight, 
			INTERVAL_VECTOR & LocErr,
			const INTERVAL & h,
			int order,
			PtrODENumeric ODE, 
			PtrODESolver Solver );
  
  ///  Destructor 
  ~ITS_DIRECT();
  
};



inline ITS_DIRECT:: ITS_DIRECT( int order )
  
  : ITS_BASE( order, MSG_ITS_DIRECT_METHOD )
{
  assert( order>0 && order<=TAYLOR_CTRL::GetMaxOrder() );
}


inline ITS_DIRECT :: ~ITS_DIRECT() 
{ 
  ;
}


#endif 
