
// FILE itsqr.cc 

#include "itsqr.h"
#include "matinv.h"
#include "qr.h"


void ITS_QR :: 
Compute( INTERVAL_VECTOR  & Ytight,  
	 INTERVAL_VECTOR  & LocErr,  
	 const INTERVAL & h, 
	 int order,
	 PtrODENumeric  ODE, 
	 PtrODESolver Solver )
{

  PtrParall Sol = GetSolution<PARALL>( ODE );
  
  // Obtain the transformation matrix and the error vector.
  const MATRIX & Aj = Sol->GetMatrix();      
  const INTERVAL_VECTOR & Rj = Sol->GetIntervalVec();

  Sj = Sj*Aj;
  
  // Compute an enclosure of the solution.
  Ytight = YpointEncl + ( Sj*Rj + LocErr );
  
  const INTERVAL_VECTOR & Yinit = ODE->GetInitEncl();
  const VECTOR & Ypoint = Sol->GetPointVec();
  
  // The tight and a priori enclosures must intersect.
  int inter = Intersection( Ytight, Yinit, Ytight );
  assert(inter);  
  
  
  RearrangeColumns( TmpMat1, Mid(Sj), Rj );
  
  QRFactorFunction( TmpMat1, TmpMat1 );
  
  OrthogonalInverse( AjInv, TmpMat1 );
  
  // An enclosure of the point solution.
  YpointEncl += LocErr;
  
  // Set the point vector,
  Sol->SetPointVec( Mid( YpointEncl ) );  
  
  // the transformation matrix 
  Sol->SetMatrix( TmpMat1 );
  
  // and the error vector
  Sol->SetIntervalVec( (AjInv*Sj)*Rj +  AjInv*(YpointEncl-Ypoint) );
  
#ifdef DEBUG
  //  if ( ODE->ExactSol() )
  //    CompareSolution( ODE, Ytight, ODE->GetTcur()+h,  __FILE__,__LINE__ );
#endif
  
}


void ITS_QR :: Init( PtrODENumeric ODE )
{
  assert( NotNull(ODE) && ODE->GetSize()>0 );  
  ResizeSpace ( ODE->GetSize() ) ;
  SetQRFunction( QRfactor );
}


void ITS_QR :: ResizeSpace ( int n )
{
  assert( n>0 );
  
  ITS_BASE::ResizeSpace( n );
  
  Resize( TmpMat1, n, n );
  Resize( AjInv, n, n );
}



