
// FILE matinv.h 

#ifndef INCLUDED_MATINV_H
#define INCLUDED_MATINV_H

#include "vnodecnf.h"

/** Encloses the inverse of a floating point approximation to an orthogonal matrix.

  @param B  a square matrix
  @param A  (output) an enclosure of the inverse of B
  */

extern void OrthogonalInverse( INTERVAL_MATRIX & A, const MATRIX & B );

/** Encloses the inverse of a matrix. The function computes an
  enclosure of the inverse of a matrix. If such an enclosure cannot be
  computed, then an error message is printed at the execution
  terminates.
  
  @param B a square point matrix
  @param A (output) an enclosure of the inverse of B, if such an enclosure can be computed
  
  @pre  RowDimension(A)==ColDimension(A) &&
  @pre  RowDimension(B)==ColDimension(B) &&
  @pre  RowDimension(A)==RowDimension(B) &&
  @pre RowDimension(A)>0 */
extern void Inverse( INTERVAL_MATRIX & A, const MATRIX & B );

#endif

