

// FILE obrtgt.cc 

#include "taylexp.h"
#include "vndinl.h"
#include "obrtgt.h"
#include "matinv.h"
#include "qr.h"
#include "messgs.h"

void IHO :: 
CompEncl( INTERVAL_VECTOR  & Ytight,  
	  INTERVAL_VECTOR  & LocalError,  
	  const INTERVAL & h, 
	  int Order,
	  PtrODENumeric  ODE, 
	  PtrODESolver Solver )
{
  
  PtrParall Sol = GetSolution<PARALL>(ODE);

  if ( Solver->AcceptedStep() )
    {
      PrevSol->SetPointVec( Sol->GetPointVec() );
      PrevSol->SetMatrix  ( Sol->GetMatrix() );
      PrevSol->SetIntervalVec( Sol->GetIntervalVec() );
    }
  else
    {
      Sol->SetPointVec( PrevSol->GetPointVec() );
      Sol->SetMatrix  ( PrevSol->GetMatrix() );
      Sol->SetIntervalVec( PrevSol->GetIntervalVec() );
    }

  
  PtrTaylExp TaylExp = GetDataRepr<TAYL_EXP>(Solver);
  
  const INTERVAL_VECTOR & Yinit = ODE->GetInitEncl();
  const INTERVAL_VECTOR & Y0  = Sol->GetTightEncl();
  const VECTOR & Ypoint = Sol->GetPointVec();
  assert(Ypoint<=Y0);

  //  Predict an enclosure of the solution with order Q+1.
  
  // Compute an approximate point solution.
  TaylExp->PointSol->GenerateTerms ( Ypoint, h, Q );  
  TaylExp->PointSol->SumTerms ( Ytight, Q );  
  
  // Compute the solution to the variational equation.
  TaylExp->VarSol->GenerateTerms ( Y0, h, Q );   
  TaylExp->VarSol->SumTerms ( Sforw, Q );
  
  // Generate the error terms.
  TaylExp->RemTerm->GenerateTerms( Yinit, h, P+Q+1 );
  
  TaylExp->RemTerm->GetOneTerm( Z, Q+1 );   
  
  const MATRIX & Aj = Sol->GetMatrix();
  const INTERVAL_VECTOR & Rj = Sol->GetIntervalVec();
  
  if ( ODE->ScalarProblem() )
    Ytight += Sforw*(Y0-Ypoint) + Z;
  else 
    {
      // y + (Sforw*Aj)*Rj + Z;
      Mtmp = Sforw *Aj;
      Z += Mtmp*Rj;
      Ytight += Z;  
    }
  int inter = Intersection( Ytight, Ytight, Yinit );
  assert(inter);  
  
  
  // Improve Ytight.
  
  // Compute an approximate forward point solution.
  Clear( Yforw );
  for ( int i = P; i >= 1 ; i-- )
    {
      TaylExp->PointSol->GetOneTerm( Z, i );
      Z *= C_pq[i];
      Yforw += Z;
    }  
  
  // Compute the forward matrix.
  Clear( Sforw );
  for ( int i = P; i >= 0 ; i-- )
    {
      TaylExp->VarSol->GetOneTerm( Mtmp, i );
      Mtmp *= C_pq[i];
      Sforw += Mtmp;
    }
  
  // Compute an appoximate backward point solution.
  YpointPred = Mid( Ytight );
  
  Clear( Yback );
  TaylExp->PointSol->GenerateTerms( YpointPred, h, Q );
  for ( int i = Q; i >= 1 ; i-- )
    {
      TaylExp->PointSol->GetOneTerm( Z, i );
      Z *= C_qp[i];
      Yback += Z;
    }
  
  dj = SubBounds(Ypoint,YpointPred );
  dj += (Yforw - Yback); 
  
  TaylExp->RemTerm->GetOneTerm( Y_1, P+Q+1 );   
  Y_1 *= ErrorConst;
  LocalError = Y_1;
  
  dj += Y_1;
  
  // Compute the backwards matrix.
  Clear( Sback );
  TaylExp->VarSol->GenerateTerms( Ytight, h, Q );
  
  for ( int i = Q; i >= 0 ; i-- )
    {
      TaylExp->VarSol->GetOneTerm( Mtmp, i );
      Mtmp *= C_qp[i];
      Sback += Mtmp;
    }
  
  Inverse( SbackInv, Mid(Sback) );
  Identity(Cj);
  Cj -= SbackInv*Sback;
  Z = Ytight - YpointPred;
  
  if ( ODE->ScalarProblem() )
    {
      Bj = (SbackInv*Sforw);
      Y_1 = (Cj*Z +  SbackInv*dj) + Bj*(Y0-Ypoint) + YpointPred;
      inter = Intersection( Ytight, Ytight, Y_1 );
      assert( inter );
      Sol->SetPointVec( Mid(Ytight) );
    }
  else
    {
      Bj = (SbackInv*Sforw)*Aj;
      Y_1 = Cj*Z;
      Y_1 += SbackInv*dj;
      Y_1 += Bj*Rj;
      Y_1 += YpointPred;
      
      inter = Intersection( Ytight, Ytight, Y_1 );
      assert( inter );
  
      RearrangeColumns( AjBB, Mid(Bj), Rj );

      QRfactor ( AjCC, AjBB );  
      
      OrthogonalInverse( AjInv, AjCC );
      
      Ymid = Mid(Ytight);
      
      Y_1 = (AjInv*SbackInv) * dj;
      Y_1 += AjInv*SubBounds(YpointPred,Ymid);
      Y_1 += (AjInv*Cj)*Z;
      Y_1 += (AjInv*Bj)*Rj;
      
      Sol->SetPointVec(Ymid);
      Sol->SetMatrix( AjCC );
      Sol->SetIntervalVec( Y_1 );
    }
}


/** Determine if an argument is an even number.
    @param k an integer
    @pre k>0
    @return true if #k# is even 
    @return false otherwise
*/
inline bool Even( int k )
{
  assert(k>=0);
  if ( k==0 ) return true;
  return ( k & 0x01 ) ? false : true;
}


INTERVAL IHO :: CompErrorConst( int p, int q )
{
  INTERVAL ErrConst(1.0);

  for ( int i = 1; i <= p; i++ )
    {
      ErrConst *= double(i);
      ErrConst /= (q+i);
    }
  
  if ( !Even(Q) )
    ErrConst = -ErrConst;
  
  return ErrConst;
}


void IHO :: 
LoadCoeff( int p, int q )
{
  // Compute the forward coefficient Cpq 
  C_pq[0] = 1.0;
  for ( int i = 1; i <= p; i++ )
    {
      C_pq[i] = ( C_pq[i-1]*double(p-i+1) )/double(q+p-i+1);
    }

  /* Compute the backward coefficients Cqp. We actually compute
     these coefficients multiplied by (-1)^i, that is (-1)^ic_i^{q,p}.
     It is helpful to multiply them by (-1)^i, because of the way we
     generate the coefficient for the ODE and its variational
     equation. */
  C_qp[0] = 1.0;
  for ( int i = 1; i <= q; i++ )
    C_qp[i] = ( (-C_qp[i-1])*double(q-i+1) ) / double(q+p-i+1);
}


void IHO :: Init ( PtrODENumeric ODE )
{
  assert(&*ODE);
  assert(ODE->GetSize()>0);  
  
  ResizeSpace ( ODE->GetSize() );
  PrevSol = new PARALL( ODE->GetSize() );
}


void IHO :: ResizeSpace ( int N )
{
  PrevSol = new PARALL(N);
  

  Resize( Ymid, N );
  
  Resize( Z, N );
  Resize( Yforw, N );
  Resize( Yback, N );
  Resize( dj, N );
  Resize( Y_1, N );

  Resize( AjBB, N, N );
  Resize( AjCC, N, N );
  Resize( Sforw, N, N );
  Resize( Sback, N, N );
  Resize( SbackInv, N, N );
  Resize( Mtmp, N, N );
  Resize( Bj, N, N );
  Resize( Cj, N, N );
  Resize( AjInv, N, N );
}


IHO :: IHO( int p, int q ) 
  : TIGHT_ENCL( p+q+1, MSG_IHO_METHOD ), P(p), Q(q)
{ 
  assert( P>0 && Q>0 && P+Q > 0 &&
	  P+Q+1 <= TAYLOR_CTRL::MaxOrder );
  
  PrevSol = NULL;
  
  C_pq = new INTERVAL[P+1]; // +1 to store the first coefficient, which is 1.
  assert(C_pq);
  
  C_qp = new INTERVAL[Q+1];
  assert(C_qp);
  
  LoadCoeff( P,Q ); 
  ErrorConst = CompErrorConst(P,Q);
};


IHO :: ~IHO()
{ 
  DELETE(PrevSol);
  delete [] C_qp;
  delete [] C_pq;
}
