
// FILE odesolv.cc 

#include <unistd.h>
#include <iostream>
#include <iomanip>

#include "vndutils.h"
#include "odesolv.h"
#include "plot.h"


void ODE_SOLVER :: PrintData( ostream & out )
{
  int OldPrec = out.precision();
  ios::fmtflags OldFlags = out.flags();
  
  out.setf( std::ios::scientific );
  out.precision(2);
  
  double Time = SolverStats->GetUserTime();
  
  out << endl;  
  
  out << " *** Integrated from " << INTERVAL(ODE->GetT0()) << " to "
      << INTERVAL(ODE->GetTcur()) << endl;
  out << " *** Global Error    " << SolverStats->GetAbsError() << endl;
  out << " *** User Time       " << Time << "(sec) ";
  if ( Time > 60 ) 
    out << ", " << Time/60.0 << " (min) " << endl;
  else 
    out << endl;
  out << " *** Accepted Steps  " << SolverStats->GetAcceptedSteps() << endl;
  out << " *** Rejected Steps  " << SolverStats->GetRejectedSteps() << endl;
  

  
  out.precision( OldPrec );
  out.setf( OldFlags );
}



void ODE_SOLVER :: SetErrors( double t, const INTERVAL_VECTOR & Y )
{
  double Ynorm    = MaxNorm( Y );
  double AbsError = MaxNorm( Diam(Y) );
  double RelError;
  
  if ( Ynorm != 0 )
    RelError = AbsError/Ynorm;
  else
    RelError = 0;
  
  SolverStats->SetAbsError( t, AbsError );
  SolverStats->SetRelError( t, RelError );
}






