
// FILE plot.h 

#ifndef INCLUDED_PLOT_H
#define INCLUDED_PLOT_H


#include <stdio.h> 
#include "IntervalVector.h"
#include "IntervalMatrix.h"



#define TMP_FILE_1           "tmpfile1" // a temporary file. 

#define TMP_FILE_2           "tmpfile2" // a temporary file. 


#define PLOT_FILE            "plot_file" 
#define SOLUTION_DATA_FILE   "solt_data"
#define PLOT_SOLUTION        "plot_solt"

#define APRIORI_DATA_FILE   "apri_data"
#define PHASE_DATA_FILE     "phase_data"
#define PLOT_PHASE           "plot_phase"
#define PLOT_APRIORI         "plot_apri"

#define STEPSIZE_DATA_FILE   "step_file"
#define PLOT_STEP            "plot_step"
#define ORDER_DATA_FILE      "order_file"
#define PLOT_ORDER           "plot_order"


///
void DeleteOutput( FILE *file, double t );

///
void OpenFiles( const char *mode );

///
void CloseFiles();

///
void WriteData( int Order, double tCur, double h,
		const INTERVAL_VECTOR & Yinit, 
		const INTERVAL_VECTOR & Ytight, bool Forward=true );

///
extern void WriteSolution( FILE *, double , const INTERVAL_VECTOR * );


///
extern void WritePhase   ( FILE *,  const INTERVAL_VECTOR & );


///
extern void WriteStepSize( FILE *,  double, double );


///
extern void WriteOrder   ( FILE *,  int, int );

#endif



