
// FILE solver1.h

#ifndef  INCLUDED_SOLVER1_H
#define  INCLUDED_SOLVER1_H

#include "vodesolv.h"
#include "itsqr.h"
#include "hoinit.h"
#include "varstep.h"
#include "constorder.h"

/** Solver class.
  
  This class implements a validated ODE solver with the \c HOE method
  for validating existence and uniqueness of the solution, the \c ITS
  method for computing a tight enclosure of the solution, variable
  stepsize control, and constant order.
  
  @author Ned Nedialkov
  @date   June 8 2001 */
class SOLVER_1 : public VODE_SOLVER
{
  
public:
  
  /** Constructor.
      
    @param ODE pointer to problem
    @param Data pointer to a data representation object
    @param order order of the method; the default value is 17
    
    @pre NotNull(ODE) && NotNull(Data) && order>0 && order <= TAYLOR_CTRL::MaxOrder 
    */
  SOLVER_1( const PtrODENumeric ODE, 
	    const PtrDataRepr Data, int order = 17 );
  
};



inline SOLVER_1 ::  SOLVER_1( const PtrODENumeric ODE, 
			      const PtrDataRepr Data, int order )
  /* The preconditions are checked in VODE_SOLVER */
  :  VODE_SOLVER( ODE, Data, 
		  new CONST_ORDER(order), 
		  new VAR_STEP_CTRL,
		  new HOE, 
		  new ITS_QR(order) ) 
{
  ;
}

#endif
