
// FILE vndnew.cc 


/* Overloading the new and delete operators.  If at the end of the
   main program MemoryLeak() > 0 then we have a memory leak.
   
   */

#ifdef DEBUG

#include <ctype.h>
#include <stdlib.h>
#include <iostream>

using namespace std;
#include "vnderror.h"


static unsigned int AllocateCounter = 0;


unsigned int MemoryLeak()
{       
  return AllocateCounter;
}


extern void * operator new (size_t siz)
{
  void * p = malloc(siz);
  
  if (!p)
    VnodeError( " new: cannot allocate memory " );
  
  ++AllocateCounter;

  //  cout << "\n new:  Memory Counter " << AllocateCounter << endl;
  return p;
}


extern void * operator new[] (size_t siz)
{
  void * p = malloc(siz);
  if (!p)
    VnodeError( " new: cannot allocate memory " );
  
  ++AllocateCounter;
  //  cout << "\n new:  Memory Counter " << AllocateCounter << endl;
  return p;
}


extern void  operator delete (void *obj)
{
  if (obj)
    {
      --AllocateCounter;
      free(obj);
    }

  //  cout << "\n delete:  Memory Counter " << AllocateCounter << endl;
}


extern void  operator delete[] (void *obj)
{
  if (obj)  
    {
      --AllocateCounter;
      free(obj);
    }
  //  cout << "\n delete:  Memory Counter " << AllocateCounter << endl;
}


#endif











