
// FILE vndobj.h 


#ifndef INCLUDED_VNDNAME_H
#define INCLUDED_VNDNAME_H


#include <string>
using namespace std;

/** Name class. It stores the name of an object.
    
    @author Ned Nedialkov  
    @date 21 February 2001
*/
class NAME
{
  
public:
  
  /// Gets the name of an object.
  const string & GetName() const;

  /// Destructor
  virtual ~NAME();
  
  
protected:
  
  /** Constructor.
      
      @param name name of an object

      @pre !name.empty()
      */
  NAME( const string & name );
  NAME(){}
  
private:
  
  /// name for an object
  string Name;
};


inline NAME :: NAME( const string & name ) : Name(name) 
{
  assert(!name.empty());
  ;
}


inline const string & NAME :: GetName() const 
{ 
  return Name; 
}



inline NAME :: ~NAME() 
{ 
  Name.~string(); 
}


#endif 
