
// FILE vndtime.cc


#include <sys/times.h>
#include <unistd.h>
#include <ctime>
#include <cstdio>
#include <assert.h>
#include "vnodecnf.h"


static struct tms Tms;
static  clock_t t;

double CPUwithTimes()
{
  // Get the current user time in seconds.
  t = times ( &Tms );
  
  if ( t == -1 )
    {
      perror("times failed");
      exit(-1);
    }
  
  BiasRoundNear();

  //  long int ClockTcks = sysconf(_SC_CLK_TCK);
  //  return ( Tms.tms_utime )/
  //    (double(ClockTcks)) ; // Convert to seconds.
  return ( Tms.tms_utime )/(double)CLK_TCK;
}


double GetTime()
{
  return CPUwithTimes();
}


double TotalTime( double start_time, double end_time )
{
  assert( start_time <= end_time );
  BiasRoundNear();
  
  return (end_time - start_time);
}

