
// FILE StiffDetestD1.h

#ifndef INCLUDED_StiffDetestD1_H
#define INCLUDED_StiffDetestD1_H


#include "odenum.h"  


template <class Y_TYPE> 
void StiffDetestD1Template( Y_TYPE *yp, const Y_TYPE *y )
{
  Y_TYPE Tmp;
  Tmp = 0.125*y[2];
  
  yp[0] =  0.2*(y[1] - y[0]);
  yp[1] =  10*y[0] - ( 60 - Tmp )*y[1] + Tmp;
  yp[2] =  1;
}

#include "declode.h" 
DECLARE_ODE_PROBLEM(StiffDetestD1,3,StiffDetestD1Template,"Stiff Detest, Problem D1");

#endif

