
// FILE TestLorenz.cc

#include "VNODE.h"    
#include "Lorenz.h"  


int main()
{
  
  VnodeInit();

  PtrODENumeric ODE = new Lorenz; 
  PtrDataRepr DataRepr = new
    TAYLOR_EXPANSION<LorenzTaylGenODE,LorenzTaylGenVAR>;
  
  ODE->LoadProblemParam( 1 );
  
  PtrVODESolver Solver_1 = new SOLVER_1( ODE, DataRepr );
  PtrVODESolver Solver_2 = new SOLVER_2( ODE, DataRepr );
  
  Solver_1->VerboseOutput(true); 
  cout << "\n*** Integrating " << ODE->GetName() << endl;
  Solver_1 -> Integrate();

  INTERVAL_VECTOR Y1( ODE->GetTightEncl() );

  Solver_2->VerboseOutput(true); 
  cout << "\n*** Integrating " << ODE->GetName() << endl;
  Solver_2 -> Integrate();

  INTERVAL_VECTOR Y2( ODE->GetTightEncl() );

  if ( !Intersection(Y1,Y2,Y1) )
    VnodeError( "VNODE error in TestLorenz.cc" );

  
  Solver_1-> SetTightEncl( new ITS_QR(25) );
  cout << "\n*** Integrating " << ODE->GetName() << endl;
  Solver_1 -> Integrate();
  
  Y1 = ODE->GetTightEncl();

  if ( !Intersection(Y2,Y2,Y1) )
    VnodeError( "VNODE error in TestLorenz.cc" );

  Solver_1-> SetTightEncl( new ITS_QR(25 ) );
  cout << "\n*** Integrating " << ODE->GetName() << endl;
  Solver_1 -> Integrate();
  
  Y1 = ODE->GetTightEncl();

  if ( !Intersection(Y2,Y2,Y1) )
    VnodeError( "VNODE error in TestLorenz.cc" );

  return 0;
}



