function printMat (M)
%
m = size (M, 1);
n = size (M, 2);
dispRow = 8;
dispCol = 2;

row = min (m, dispRow / 2);
col = min (n, dispCol - 1);
for (i = 1 : row) 
    for (j = 1 : col) 
        fprintf ('%17.14f %+17.14fi', real (M(i,j)), imag (M(i,j)));
        if ((j ~= col) | ((j == col) & (n <= dispCol))) 
            fprintf ('  ');
        end
    end

    if (n > dispCol) 
        fprintf (' ... ');
    end

    fprintf ('%17.14f %+17.14fi', real (M(i, n-1)), imag (M(i, n-1)));
    fprintf ('\n');
end

if (m > dispRow) 
    fprintf (' ...... ......\n');
    fprintf (' ...... ......\n');
else 
    return;
end

row = min (dispRow / 2, m - row);
for (i = (m - row + 1) : m) 
    for (j = 1 : col) 
        fprintf ('%17.14f %+17.14fi', real (M(i,j)), imag (M(i,j)));
        if ((j ~= col) | ((j == col) & (n <= dispCol))) 
            fprintf ('  ');
        end
    end
    if (n > dispCol) 
        fprintf (' ... ');
    end

    fprintf ('%17.14f %+17.14fi', real (M(i, n-1)), imag (M(i, n-1)));
    fprintf ('\n');
end
